//
//=================================================
// QUEST.GDB
//=================================================
//#quest <name>
//{
//   description
//     desc string "<Description of the quest>"
//   experience awarded upon completion:
//     xp   int    <value>
//   When completed, the next sub-quest can continue with:
//     next_quest string  "<name>"
//   When completed, this APE sequence callback will be triggered
//     quest_callback string "<sequence>"
//   When this quest is added, the following sub_quest will also be added //immediately
//     sub_quest string "<sub_quest>"
//     @@@ OBSOLETE!!!! Gamevar expression to indicate that the quest is done:
//     @@@                   requirement string "<expr>"
//}
// QUEST COMMANDS
// extern add_quest "The Name of The Quest"
// extern complete_quest "The Name of The Quest"
// extern cancel_quest "The Name of The Quest"
// extern is_quest_done "The Name of The Quest" GAMEVAR
//is_quest_done will check to see if you've finished the specified quest, and return
//a value to the GAMEVAR specified. All successfully finished quests will return 2,
//a quest "in progress" will return 1 and a quest you haven't received will return
//0. NOTE that this can be kinda expensive to check, so it shouldn't be used to check 
//every frame if the status of a Quest has changed from 1 to 2, or something like that.
//Use this call with care, and stick to checking the normal gamevars when possible.

//#########################################################################
// ANACHRONOX
//#########################################################################

//=========================================================================
// DO INTRO STUFF IN ROWDY'S TO LEARN
//=========================================================================
#quest Fatima Stop
{
type string "quest"
area string "Anachronox"
desc string "Erledige das, sonst lasse ich dich gar nicht heraus:"
// xp int 200
xp_shares	float	10
sub_quest string "Get Your Camera;Get Some Money;Use Time Minder;Talk To Valesta"
}

#quest Get Your Camera
{
area string "Anachronox"
type string "sub_quest"
desc string "Nimm die Kamera aus deinem B#ro mit."
// xp int 50
xp_shares	float	1
quest_parent string "Fatima Stop"
}

#quest Get Some Money
{
area string "Anachronox"
type string "sub_quest"
desc string "Finde etwas Geld in deinem B#ro. Vielleicht findest du etwas im Hinterzimmer."
// xp int 100
xp_shares	float	1
quest_parent string "Fatima Stop"
}

#quest Use Time Minder
{
area string "Anachronox"
type string "sub_quest"
desc string "Streichle den TimeMinder. Das bringt Gl#ck."
// xp int 100
xp_shares	float	1
quest_parent string "Fatima Stop"
}

#quest Talk To Valesta
{
area string "Anachronox"
type string "sub_quest"
desc string "Besorge dir einen Auftrag."
// xp int 100
xp_shares	float	1
quest_parent string "Fatima Stop"
}


//=========================================================================
// Learn How To Beat
//=========================================================================
#quest Go To Whackmaster
{
area string "Anachronox"
type string "quest"
desc string "Besuche Kampfmeister Jack. Lerne wie ein Mann zu k[mpfen. Nur ein Ratschlag von mir."
// xp int 1000
xp_shares	float	1
}


//=========================================================================
// GET GRUMPOS
//=========================================================================
#quest Find A Job
{
area string "Anachronox"
type string "quest"
desc string "Finde einen Job, S#^er."
// requirement string "GOT_GRUMPOS=1"
// xp int 1000
xp_shares	float	8
}


// Added by APE
#quest Talk To Deanamo
{
quest_parent string "Find A Job"
type string "sub_quest"
area string "Anachronox"
desc string "Deanamo wurde f#r einen Job angeheuert. Dich k<nnte man auch gebrauchen. Sie ist in Franks Penne."
// requirement string "MET_DEANAMO=1"
// xp int 50
}

#quest Find Grumpos
{
quest_parent string "Find A Job"
type string "sub_quest"
area string "Anachronox"
desc string "Jemand namens Grumpos heuerte Deanamo an. Sie schaffte den Job nicht. Nun ist es deine Chance, Kohle zu verdienen. Sie sagte, er wohnt irgendwo in diesem Gebiet."
// requirement string "MET_GRUMPOS=1"
// xp int 50
}

#quest Find Matavastros
{
quest_parent string "Find A Job"
type string "sub_quest"
area string "Anachronox"
desc string "Vielleicht wird Grumpos Matavastros dich f#r diesen Job anheuern. Sie sagte, er wohnt im Haus Nummer 5, links von dem Theater. Suche dort nach ihm. Und versuche wie ein Profi zu handeln."
// requirement string "MET_GRUMPOS=1"
// xp int 50
xp_shares	float	2
}


#quest Get Hired By Grumpos
{
quest_parent string "Find A Job"
area string "Anachronox"
type string "sub_quest"
desc string "Du musst den Gr<^e-F#nf Helm finden, bevor Grumpos Matavastros dich anheuern wird."
// requirement string "GOT_GRUMPOS=1"
// xp int 1000
}



#quest Clue To Helmet
{
quest_parent string "Get Hired By Grumpos"
area string "Anachronox"
desc string "Es muss einen NoxGuard mit einem kleinen Helm geben. Sieh auf der Landeplattform nach."
// requirement string "INV_TREE=1"
// xp int 50
type string "sub_quest"
}


#quest Get Stuff to Grumpos
{
quest_parent string "Get Hired By Grumpos"
area string "Anachronox"
desc string "Nicht schlecht, Boots. Ich meine, nichts Gro^artiges, aber nicht schlecht. Komm schon, bring den Helm zu dem alten Mann."
// requirement string "GOT_GRUMPOS=1"
// xp int 50
type string "sub_quest"
}

//=================================================================================
// GET INTO THE MYSTECH TUNNELS
//=================================================================================
#quest Get Into MysTech Tunnels
{
area string "Anachronox"
desc string "Wir m#ssen die MysTech-Tunnel betreten."
// requirement string "ENTERED_TUNNELS=1"
// xp int 250
type string "quest"
//sub_quest string "Got Linguinator"
}

#quest How To Get Past Tunnel Guard
{
quest_parent string "Get Into MysTech Tunnels"
area string "Anachronox"
desc string "Schlecht. Mephad der T#rsteher, bewacht den Tunneleingang. Wir haben ein Problem."
// xp int 50
xp_shares	float	1
type string "sub_quest"
}


#quest Know about Conrad
{
type string "quest"
area string "Anachronox"
desc string "Der Floater K' Conrad Khk h[ngt auf der Aussichtsplattform bei der Quellenspirale herum. Er soll der beste Informant in ganz Bricks sein. Komisch, dass wir noch nie etwas von ihm h<rten."
// xp int 50
}

#quest Talk to Conrad
{
type string "quest"
area string "Anachronox"
desc string "Ein Floater namens K' Conrad Khk ist ein Informationsspezialist. Er wartet auf den Informationstausch auf der Aussichtsplattform bei der Quellenspirale."
// xp int 50
}

#quest Conrad Might Know
{
quest_parent string "Eddie Knows Tunnels"
type string "quest"
area string "Anachronox"
desc string "Halte mich f#r verr#ckt, aber vielleicht wei^ K' Conrad Khk irgendetwas #ber diesen Eddie...."
// xp int 50
}

#quest Find More Info on Eddie
{
area string "Anachronox"
desc string "Es gibt hier irgendwo einen Kerl namens "Eddie", der "Bescheid wei^". Du kannst immer gute Kontakte gebrauchen, also finde ihn."
// xp int 50
xp_shares	float	1
type string "sub_quest"
}

#quest Eddie Knows Tunnels
{
quest_parent string "Find More Info on Eddie"
area string "Anachronox"
desc string "Dieser Eddie muss wissen, wie man in die MysTech-Tunnel kommt. Wir sollten ihn aufsuchen und etwas ausquetschen."
// xp int 50
type string "sub_quest"
}

#quest Know Lucko
{
quest_parent string "Eddie Knows Tunnels"
area string "Anachronox"
desc string "Ein Kerl namens "Lucko" Coldwolf kann uns zu Eddie f#hren. Wir m#ssen ihm folgen. Er bringt uns vielleicht zu diesem Eddie."
// xp int 50
xp_shares	float	1
type string "sub_quest"
}

#quest Find Lucko
{
quest_parent string "Know Lucko"
area string "Anachronox"
desc string "Sein letzter Aufenthalt war 628 Barton Arms in den oberen Leveln des Wohnbereiches."
// xp int 50
type string "sub_quest"
}

#quest Know Where Eddie Is
{
quest_parent string "Eddie Knows Tunnels"
area string "Anachronox"
desc string "Er lebt am Schuttplatz. Wir m#ssen ihm etwas bringen, damit wir mit ihm sprechen k<nnen. Etwas Stinkendes und Ekelhaftes zum Kauen. Genau."
// xp int 50
type string "sub_quest"
}

#quest Know About Sock
{
quest_parent string "Know Where Eddie Is"
area string "Anachronox"
desc string "Es gibt einen humpelnden Kerl in der N[he der Quellenspirale. Er tr[gt eine wirklich stinkende Socke. Ist sie vielleicht ekelhaft genug?"
// xp int 50
type string "sub_quest"
}

#quest Have Sock For Eddie
{
quest_parent string "Know Where Eddie Is"
area string "Anachronox"
desc string "Bringe diese stinkende Socke zu Eddie am Schuttplatz."
// xp int 50
type string "sub_quest"
}

#quest Know How To Get Past Guard
{
quest_parent string "Get Into MysTech Tunnels"
area string "Anachronox"
desc string "Eddie sagte, wir sollen den T#rsteher #ber... na ja, du wei^t schon... fragen."
// requirement string "ENTERED_TUNNELS=1"
// xp int 50
type string "sub_quest"
}

#quest Explore The Tunnels
{
area string "Anachronox"
desc string "Hilf Mr. Matavastros, die MysTech-Tunnel zu erforschen. Versaue es nicht, Boots. Wir brauchen die Knete."
// requirement string "GOT_STRANGESTONE=1"
// xp int 50
type string "quest"
}

#quest Find Rho Bowman
{
area string "general"
desc string "Fliege auf Sunder und finde Dr. Rho Bowman. Grumpos will mit ihr #ber MysTech sprechen."
// requirement string "MET_RHO=1"
// xp int 250
type string "quest"
sub_quest string "Get To Sender Station"
}

#quest Get To Sender Station
{
quest_parent string "Find Rho Bowman"
area string "Anachronox"
desc string "Nehmt mit Grumpos ein Shuttle von Tours zu Sender Station. Ist immerhin besser, als hier herumzulungern, meinst du nicht?"
// requirement string "LEAVE_BRICKS_FIRST_TIME=1"
// xp int 50
xp_shares	float	1
type string "sub_quest"
//next_quest string "Get to Sunder"
}

#quest Get To South Platform
{
quest_parent string "Get To Sender Station"
area string "Anachronox"
desc string "OK, ihr habt die Tickets. Nehmt das Shuttle auf der S#d-Plattform."
// requirement string "LEAVE_BRICKS_FIRST_TIME=1"
// xp int 50
type string "sub_quest"
}

#quest Get To North Platform
{
area string "Anachronox"
desc string "Ihr habt die Tickets nach OneGate. Nehmt ein Shuttle von der Nord-Plattform, wenn ihr fertig seid."
// requirement string "LEAVE_BRICKS_FIRST_TIME=1"
// xp int 50
type string "quest"
}

//=========================================================================
// GENERAL GOALS, BUT STARTED IN BRICKS
//=========================================================================
#quest Get PAL Battery
{
quest_parent string "Get To Sender Station"
area string "Anachronox"
desc string "Aber nicht, bevor du in Rowdys Bar zur#ckkehrst und PAL-18 mit der Gr<^e-B Batterie reaktivierst. Wie kannst du es nur wagen, ihn hier zu lassen?"
// requirement string "GOT_PAL=1"
// xp int 1000
type string "sub_quest"
}

#quest Get PAL Battery Back
{
quest_parent string "Get PAL Battery"
area string "Anachronox"
desc string "Schon viel besser, Boots. Wenn du dich jetzt zu Rowdys Bar beeilst und PAL reaktivierst, werde ich ihm vielleicht NICHT erz[hlen, dass du ihn fast vergessen h[ttest."
// requirement string "GOT_PAL=1"
// xp int 1000
type string "sub_quest"
}


//#########################################################################
// SENDER STATION
//#########################################################################

//=========================================================================
// GOALS-SENDER STATION (first time)
//=========================================================================
// GET TICKETS
//=========================================================================
#quest Get To Sunder
{
quest_parent string "Find Rho Bowman"
area string "Sender Station"
desc string "Findet einen Ticketschalter und besorgt euch Tickets f#r ein Shuttle von Senderstation auf Sunder."
// requirement string "NEED_SUNDER_TICKETS = 1"
// xp int 50
type string "sub_quest"
}

#quest Get Two Tickets To Sunder
{
quest_parent string "Find Rho Bowman"
area string "Sender Station"
desc string "Besorgt zwei Tickets f#r das in Gate 5 angedockte Schuttle auf Sunder."
// requirement string "BEEN_TO_SUNDER=1"
// xp int 50
xp_shares	float	.5
type string "sub_quest"
}

#quest Get One Ticket To Sunder
{
quest_parent string "Find Rho Bowman"
area string "Sender Station"
desc string "Besorgt euch noch ein Ticket f#r das in Gate 5 angedockte Shuttle auf Sunder."
// requirement string "BEEN_TO_SUNDER=1"
// xp int 50
xp_shares	float	.5
type string "sub_quest"
}

//=========================================================================
// GET ON BRAIN TRAIN
//=========================================================================

#quest Get On Sunder Shuttle No Know
{
quest_parent string "Find Rho Bowman"
area string "Sender Station"
desc string "OK, wir haben die Tickets. Jetzt m#ssen wir es nur noch irgendwie auf diesen Brain Train schaffen."
// requirement string "BEEN_TO_SUNDER=1"
// xp int 50
type string "sub_quest"
}

#quest Get On Sunder Shuttle Do Know
{
quest_parent string "Find Rho Bowman"
area string "Sender Station"
desc string "Wenn ihr die Tickets habt, m#sst ihr noch Folgendes tun, um in den Brain Train auf Sunder einsteigen zu d#rfen:"
// requirement string "BEEN_TO_SUNDER=1"
// xp int 250
xp_shares	float	4
sub_quest string "Get Past Sunder Shuttle Door;Look Like Scientists;Get Past Brain Bouncer"
type string "sub_quest"
}

#quest Get Past Sunder Shuttle Door
{
area string "Sender Station"
desc string "Ihr m#sst die Sicherheitst#r in Gate 5 #berwinden."
// requirement string "GATE5_OPENED=1"
// xp int 50
xp_shares	float	1
quest_parent string "Get On Sunder Shuttle Do Know"
type string "sub_quest"
}

#quest Look Like Scientists
{
area string "Sender Station"
desc string "Ihr m#sst wie echte Wissenschaftler aussehen."
// requirement string "INV_LABCOATS=1"
// xp int 50
xp_shares	float	1
quest_parent string "Get On Sunder Shuttle Do Know"
type string "sub_quest"
}

#quest Get Past Brain Bouncer
{
area string "Sender Station"
desc string "Ihr m#sst am Brain Bouncer vorbeikommen."
// requirement string "PASSED_BRAINBOUNCER=1"
// xp int 500
quest_parent string "Get On Sunder Shuttle Do Know"
type string "sub_quest"
}

//=========================================================================
// GOALS-SENDER STATION (part 2)
//=========================================================================
// SS INFO: MAYBE INFO SECTION SHOULD BE IN GDB TOO
//=========================================================================

//=========================================================================
// GET FTM
//=========================================================================
#quest Need To Get FTM
{
area string "Sender Station"
desc string "Wir brauchen ein Feld#bertragungsmodul (F%M), damit Dr. Bowman den Tachionenzerfallsdetektor (TZD) benutzen kann, wenn wir einen besorgt haben."
// requirement string "KNOW_ABOUT_PHUNKEE=1;GOT_WEDDING_RING=1;TALK_PHUNKEE=1"
// xp int 250
type string "quest"
}

#quest Need To Talk to Kevester
{
quest_parent string "Need To Get FTM"
area string "Sender Station"
desc string "Findet Kevester, einen Schwarzmarktdealer im Rotlichtviertel, und findet heraus, wo man ein Feld#bertragungsmodul f#r Dr. Bowman bekommt."
// requirement string "KNOW_ABOUT_FTM=1;TALK_PHUNKEE=1"
// xp int 50
type string "sub_quest"
}

#quest Need To Talk to Sam 
{
quest_parent string "Need To Talk to Kevester"
area string "Sender Station"
desc string "Sam Schlung bei der Wahrsagerin Marina k<nnte wissen, wo Kevester zu finden ist."
// requirement string "TALK_SCHLUNG=1"
// xp int 50
type string "sub_quest"
}

#quest Know Where Kevester Is
{
quest_parent string "Need To Talk To Kevester"
area string "Sender Station"
desc string "Findet Kevester Kopp in Slutopia im Rotlichtviertel."
// requirement string "RING_IN_ROOM_2=1"
// xp int 50
type string "sub_quest"
}

#quest Need Kevester Ring
{
quest_parent string "Need To Get FTM"
area string "Sender Station"
desc string "Wenn wir Kevester Kopps Ehering im Zimmer 2 des "Orangenen Zentrums" finden, wird er uns mit dem F%M versorgen."
// requirement string "GOT_WEDDING_RING=1"
// xp int 50
type string "sub_quest"
}

#quest Return Kevester Ring
{
quest_parent string "Need To Get FTM"
area string "Sender Station"
desc string "Lasst uns den Ehering zur#ck zu Kevester in Slutopia abliefern und sehen, ob seine Kontakte ihm etwas geholfen haben."
// requirement string "KNOW_ABOUT_PHUNKEE=1"
// xp int 50
type string "sub_quest"
}

#quest Talk To Phunkee
{
quest_parent string "Need To Get FTM"
area string "Sender Station"
desc string "Fragt Phunkee Collins aus dem Rotlichtviertel nach dem F%M."
// requirement string "KNOW_ABOUT_PHUNKEE=1;TALK_PHUNKEE=1"
// xp int 50
type string "sub_quest"
}

#quest Return with FTM
{
area string "Sender Station"
desc string "Bringt das F%M zu dem Rest der Party in der Lounge of Commerce."
// requirement string "PAL_GOT_TDD=1"
// xp int 250
xp_shares	float	1
type string "quest"
}

//=========================================================================
// GET TDD
//=========================================================================
#quest Need To Get TDD
{
area string "Sender Station"
desc string "Du musst irgendwie den Prototypen des Tachionzerfallsdetektor (TZD) aus dem Theoretischen Wissenschaftsmuseum auf Sender Station besorgen."
// requirement string "PAL_GOT_TDD=1"
// xp int 250
type string "quest"
}

#quest PAL Get TDD
{
area string "Sender Station"
desc string "Rolle deinen kleinen Hintern zu dem Wissenschaftsmuseum und schnappe dir dort diesen Prototypen des TZD. Ich wei^, dass du es schaff kannst, PAL."
// requirement string "PAL_GOT_TDD=1"
// xp int 250
type string "quest"
}

#quest Return with TDD
{
area string "Sender Station"
desc string "Bringe den TZD zum Rest der Party in der Lounge Of Commerce."
// requirement string "PAL_GOT_TDD=1"
// xp int 250
xp_shares	float	1
type string "quest"
}


//#########################################################################
// SUNDER
//#########################################################################
//=========================================================================
// MEET RHO
//=========================================================================

#quest Get to Rho
{
quest_parent string "Find Rho Bowman"
area string "Sunder"
desc string "Dr. Rho Bowman ist im Regenbogen-Tempel in der N[he des Weltraumhafens. Findet diesen Ort und ihr werdet sie finden."
// requirement string "MET_RHO=1"
// xp int 50
type string "sub_quest"
}

#quest Get Laser Frequencies
{
quest_parent string "Get to Rho"
area string "Sunder"
desc string "Security-Laser blockieren den weiteren Weg zum Regenbogen-Tempel. Jede PAX-Wache kennt jeweils eine Laser-Frequenz."
// requirement string "MET_RHO=1"
// xp int 200
type string "sub_quest"
sub_quest string "Get Red Laser Frequency;Get Green Laser Frequency;Get Blue Laser Frequency"
}

#quest Get Red Laser Frequency
{
quest_parent string "Get Laser Frequencies"
area string "Sunder"
desc string "Ihr m#sst die Frequenz f#r den inaktiven Zustand der Roten Laserstrahlen herausfinden."
// requirement string "MET_RHO=1"
// xp int 50
type string "quest"
}

#quest Disable Red Laser
{
quest_parent string "Get Laser Frequencies"
area string "Sunder"
desc string "Die Frequenz f#r den inaktiven Zustand der Roten Laserstrahlen ist 507. Der Rote Laser kann nun deaktiviert werden."
// requirement string "MET_RHO=1"
// xp int 50
xp_shares	float	2
type string "quest"
}

#quest Get Green Laser Frequency
{
quest_parent string "Get Laser Frequencies"
area string "Sunder"
desc string "Ihr m#sst die Frequenz f#r den inaktiven Zustand der Gr#nen Laserstrahlen herausfinden."
// requirement string "MET_RHO=1"
// xp int 50
type string "quest"
}

#quest Disable Green Laser
{
quest_parent string "Get Laser Frequencies"
area string "Sunder"
desc string "Die Frequenz f#r den inaktiven Zustand der Gr#nen Laserstrahlen ist 691. Der Gr#ne Laser kann nun deaktiviert werden."
// requirement string "MET_RHO=1"
// xp int 50
xp_shares	float	2
type string "quest"
}

#quest Get Blue Laser Frequency
{
quest_parent string "Get Laser Frequencies"
area string "Sunder"
desc string "Ihr m#sst die Frequenz f#r den inaktiven Zustand der Blauen Laserstrahlen herausfinden."
// requirement string "MET_RHO=1"
// xp int 50
type string "quest"
}

#quest Disable Blue Laser
{
quest_parent string "Get Laser Frequencies"
area string "Sunder"
desc string "Die Frequenz f#r den inaktiven Zustand der Blauen Laserstrahlen ist 493. Der Blaue Laser kann nun deaktiviert werden."
// requirement string "MET_RHO=1"
// xp int 50
xp_shares	float	2
type string "quest"
}

#quest Find Laser Blocker
{
quest_parent string "Get Laser Frequencies"
area string "Sunder"
desc string "Ihr braucht einen d#nnen Gegenstand, um die eingestellten Frequenzen zu unterbrechen."
// requirement string "MET_RHO=1"
// xp int 50
type string "quest"
}

#quest Found Laser Blocker
{
quest_parent string "Get Laser Frequencies"
area string "Sunder"
desc string "Vielleicht sind diese Spielkarten d#nn genug, um die Laserstrahlen zu unterbrechen. Mal sehen."
// requirement string "MET_RHO=1"
// xp int 50
type string "quest"
}

#quest Starport Lasers Down
{
quest_parent string "Find Rho Bowman"
area string "Sunder"
desc string "OK, die Security Laser sind ausgeschaltet. Wir m#ssen nun nach Dr. Bowman im Regenbogen-Sanktuarium suchen."
// requirement string "MET_RHO=1"
// xp int 50
type string "sub_quest"
}

#quest Follow Cachepence
{
quest_parent string "Find Rho Bowman"
area string "Sunder"
desc string "Folgt Ms. Cachepence zu Dr. Bowmans Labor. Und h<r auf, auf ihren Hintern zu glotzen, Boots."
// requirement string "MET_RHO=1"
// xp int 50
type string "sub_quest"
}


//=========================================================================
// GET OFF SUNDER!
//=========================================================================

#quest Find Rho Shuttlekey
{
area string "Sunder"
desc string "Was macht ihr?! Helft Dr. Bowman, ihre Chipkarte f#r die Shuttledocks zu finden! SOFORT!"
type string "quest"
}

#quest Get To Starport Gate
{
area string "Sunder"
desc string "BEEILT EUCH ZUM SHUTTLE IN GATE 12 ODER WIR SIND ALLE TOT! (Eigentlich seid IHR alle tot. Ich bin es ja bereits.)"
// xp int 50
xp_shares	float	12
type string "quest"
}

//#########################################################################
// DEMOCRATUS
//#########################################################################

//=========================================================================
// EXPLORE VOTOWNE, GET INTO CHAMBERS
//=========================================================================
#quest Democratus Unknown
{
area string "Democratus"
desc string "Dieser Planet. Wir m#ssen hier weg. Sprich mit den Anderen."
// xp int 50
type string "quest"
}

#quest Democratus Known
{
area string "Democratus"
desc string "Der Hohe Rat scheint hier alles zu regeln. Wenn wir mit seinen Mitgliedern sprechen, k<nnten wir sie vielleicht davon #berzeugen, unser Shuttle zu reparieren, damit wir von hier verschwinden k<nnen."
// xp int 50
type string "quest"
}

#quest Need To Vote
{
quest_parent string "Democratus Known"
area string "Democratus"
desc string "Um zu dem Hohen Rat vorgelassen zu werden, m#ssen wir genauso wie er in der heutigen Wahl abstimmen und die Goldene VoteKarte bekommen."
// xp int 50
type string "sub_quest"
}

#quest Need To Register
{
quest_parent string "Need To Vote"
area string "Democratus"
desc string "Um w[hlen zu d#rfen, m#ssen wir registriert sein."
// xp int 50
type string "sub_quest"
}

#quest Need To Know All Council Votes
{
quest_parent string "Need To Vote"
area string "Democratus"
desc string "Wir m#ssen die Verb#ndeten des Hohen Rates finden. Sie sind mit sechs Perlen der Weisheit auf ihrem Gesicht markiert. Wir m#ssen herausfinden, wie die Entscheidung des Hohen Rates bei folgenden Abstimmungen lautet:"
// xp int 50
sub_quest string "What is Proposition 1 Vote;What is Proposition 2 Vote;What is Proposition 3 Vote;What is Proposition 4 Vote;What is Proposition 5 Vote;What is Proposition 6 Vote;What is Proposition 7 Vote;What is Proposition 8 Vote"
type string "sub_quest"
}

//----------------- 1 -----------------------------
#quest What is Proposition 1 Vote
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
desc string "Die Abstimmung des Hohen Rates beim 1. Wahlantrag? (Maximaler Rampenwinkel)"
// xp int 50
xp_shares	float	1
type string "sub_quest"
}

#quest Know Proposition 1 Vote YES
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
desc string "Verb#ndete des Hohen Rates w[hlen 'JA' beim 1. Wahlantrag."
//desc string "Allies of the Council vote YES on Proposition 1, making the maximum ramp angle throughout Votowne: 45 degrees."
// xp int 100
type string "sub_quest"
}

#quest Know Proposition 1 Vote NO
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
//desc string "Allies of the Council vote NO on Proposition 1, making the maximum ramp angle throughout Votowne: 45 degrees."
desc string "Verb#ndete des Hohen Rates w[hlen 'NEIN' beim 1. Wahlantrag."
// xp int 100
type string "sub_quest"
}
//----------------- 2 -----------------------------
#quest What is Proposition 2 Vote
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
desc string "Die Abstimmung des Hohen Rates beim 2. Wahlantrag? (Erbrechenfolter f#r M<rder an der Planetenoberfl[che)"
// xp int 50
xp_shares	float	1
type string "sub_quest"
}

#quest Know Proposition 2 Vote YES
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
//desc string "Allies of the Council vote YES on Proposition 2, abolishing Cyclical Vomit Torture as a form of punishment for first degree murder commited by Planet-dwellers."
desc string "Verb#ndete des Hohen Rates w[hlen 'JA' beim 2. Wahlantrag."
// xp int 100
type string "sub_quest"
}

#quest Know Proposition 2 Vote NO
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
desc string "Verb#ndete des Hohen Rates w[hlen 'NEIN' beim 2. Wahlantrag."
// xp int 100
type string "sub_quest"
}
//----------------- 3 -----------------------------
#quest What is Proposition 3 Vote
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
desc string "Die Abstimmung des Rates beim 3. Wahlantrag? (Verkauf von Fliegenr#ben)"
// xp int 50
xp_shares	float	1
type string "sub_quest"
}

#quest Know Proposition 3 Vote YES
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
//desc string "Allies of the Council vote YES on Proposition 3, making the preparation, and selling of dangerous squizzle beets for consumption a misdemeanor."
desc string "Verb#ndete des Hohen Rates w[hlen 'JA' beim 3. Wahlantrag."
// xp int 100
type string "sub_quest"
}

#quest Know Proposition 3 Vote NO
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
//desc string "Allies of the Council vote NO on Proposition 3, making the preparation, and selling of dangerous squizzle beets for consumption a misdemeanor."
desc string "Verb#ndete des Hohen Rates w[hlen 'NEIN' beim 3. Wahlantrag."
// xp int 100
type string "sub_quest"
}

//----------------- 4 -----------------------------
#quest What is Proposition 4 Vote
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
desc string "Die Abstimmung des Rates beim 4. Wahlantrag? (Offizielle Farbe zum Festival der Wahl)"
// xp int 50
xp_shares	float	1
type string "sub_quest"
}

#quest Find Halpern Assistant
{
quest_parent string "What is Proposition 4 Vote"
area string "Democratus"
desc string "Der Assistent des Abgeordneten Halperts mietet Zimmer 201 im Republikgasthof. Er sollte wissen, wie der Hohe Rat sich beim 4. Wahlantrag entschieden hat."
// requirement string "ROOM201=1"
// xp int 50
type string "sub_quest"
}

#quest Know Proposition 4 Vote YES
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
//desc string "Allies of the Council vote YES on Proposition 4, making pousse-cafe the official color of next year's Festival of Choice."
desc string "Verb#ndete des Hohen Rates w[hlen 'JA' beim 4. Wahlantrag."
// requirement string "KNOW_ALL_VOTES=1"
// xp int 100
type string "sub_quest"
}

#quest Know Proposition 4 Vote NO
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
//desc string "Allies of the Council vote NO on Proposition 4, making pousse-cafe the official color of next year's Festival of Choice."
desc string "Verb#ndete des Hohen Rates w[hlen 'NEIN' beim 4. Wahlantrag."
// requirement string "KNOW_ALL_VOTES=1"
// xp int 100
type string "sub_quest"
}

//----------------- 5 -----------------------------
#quest What is Proposition 5 Vote
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
desc string "Die Abstimmung des Rates beim 5. Wahlantrag? (Strafe f#r Au^enwelter, in deren Besitz Drogen gefunden wurden)"
// requirement string "PROP5=1"
// xp int 50
xp_shares	float	1
type string "sub_quest"
}

#quest Know Proposition 5 Vote YES
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
//desc string "Allies of the Council vote YES on Proposition 5, making outworlder possession of narcotics punishable by death-likely sentence (immediate complete use of all substances in possession)."
desc string "Verb#ndete des Hohen Rates w[hlen 'JA' beim 5. Wahlantrag."
// requirement string "KNOW_ALL_VOTES=1"
// xp int 100
type string "sub_quest"
}

#quest Know Proposition 5 Vote NO
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
//desc string "Allies of the Council vote NO on Proposition 5, making outworlder possession of narcotics punishable by death-likely sentence (immediate complete use of all substances in possession)."
desc string "Verb#ndete des Hohen Rates w[hlen 'NEIN' beim 5. Wahlantrag."
// requirement string "KNOW_ALL_VOTES=1"
// xp int 100
type string "sub_quest"
}
//----------------- 6 -----------------------------
#quest What is Proposition 6 Vote
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
desc string "Die Abstimmung des Rates beim 6. Wahlantrag? (Bipidrifleischverkauf als Kapitalverbrechen)"
// requirement string "PROP6=1"
// xp int 50
xp_shares	float	1
type string "sub_quest"
}

#quest Know Proposition 6 Vote YES
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
//desc string "Allies of the Council vote YES on Proposition 6, making it a felony to possess, sell or export Bipidri meat for globbering consumption."
desc string "Verb#ndete des Hohen Rates w[hlen 'JA' beim 6. Wahlantrag."
// requirement string "KNOW_ALL_VOTES=1"
// xp int 100
type string "sub_quest"
}

#quest Know Proposition 6 Vote NO
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
//desc string "Allies of the Council vote NO on Proposition 6, making it a felony to possess, sell or export Bipidri meat for globbering consumption."
desc string "Verb#ndete des Hohen Rates w[hlen 'NEIN' beim 6. Wahlantrag."
// requirement string "KNOW_ALL_VOTES=1"
// xp int 100
type string "sub_quest"
}
//----------------- 7 -----------------------------
#quest What is Proposition 7 Vote
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
desc string "Die Abstimmung des Rates beim 7. Wahlantrag?? (Abforstung des Waugee-Waldes)"
// requirement string "PROP7=1"
// xp int 50
xp_shares	float	1
type string "sub_quest"
}

#quest Find Dass Daskan
{
quest_parent string "What is Proposition 7 Vote"
area string "Democratus"
desc string "Findet Dass Daskan im Zimmer 401 im Republikgasthof. Er wei^, wie der Hohe Rat sich beim 7. Wahlantrag entschieden hat."
// requirement string "FIND_DASKAN=1"
// xp int 50
type string "sub_quest"
}

#quest Find Dass Daskan With Map
{
quest_parent string "What is Proposition 7 Vote"
area string "Democratus"
desc string "Findet Dass Daskan, den Mann, der #ber die Entscheidung des Hohen Rates betreffs des 7. Wahlantrages Bescheid wei^. Rho schl[gt vor, Daskans Notiz zu einem hochliegenden Aussichtspunkt mitzunehmen."
// requirement string "PROP7=1"
// xp int 50
type string "quest"
}

#quest Know Proposition 7 Vote YES
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
//desc string "Allies of the Council vote YES on Proposition 7, allowing deforestation of Waugees forest for dort-herding land."
desc string "Verb#ndete des Hohen Rates w[hlen 'JA' beim 7. Wahlantrag."
// requirement string "KNOW_ALL_VOTES=1"
// xp int 100
type string "sub_quest"
}

#quest Know Proposition 7 Vote NO
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
//desc string "Allies of the Council vote NO on Proposition 7, allowing deforestation of Waugees forest for dort-herding land."
desc string "Verb#ndete des Hohen Rates w[hlen 'NEIN' beim 7. Wahlantrag."
// requirement string "KNOW_ALL_VOTES=1"
// xp int 100
type string "sub_quest"
}
//----------------- 8 -----------------------------
#quest What is Proposition 8 Vote
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
desc string "Die Abstimmung des Rates beim 8. Wahlantrag? (Eheschlie^ungen zwischen Ring- und Oberfl[chenbewohnern)"
// requirement string "PROP8=1"
// xp int 50
xp_shares	float	1
type string "sub_quest"
}

#quest Know Proposition 8 Vote YES
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
//desc string "Allies of the Council vote YES on Proposition 8, making marriages between Ring-dwellers and Planet-dwellers recognized by the state."
desc string "Verb#ndete des Hohen Rates w[hlen 'JA' beim 8. Wahlantrag."
// requirement string "KNOW_ALL_VOTES=1"
// xp int 100
type string "sub_quest"
}

#quest Know Proposition 8 Vote NO
{
quest_parent string "Need To Know All Council Votes"
area string "Democratus"
//desc string "Allies of the Council vote NO on Proposition 8, making marriages between Ring-dwellers and Planet-dwellers recognized by the state."
desc string "Verb#ndete des Hohen Rates w[hlen 'NEIN' beim 8. Wahlantrag."
// requirement string "KNOW_ALL_VOTES=1"
// xp int 100
type string "sub_quest"
}

#quest Need To Use Ally Card
{
quest_parent string "Democratus Known"
area string "Democratus"
desc string "Wir haben endlich diese Goldene VoteKarte. Lasst uns nun den Hohen Rat treffen und dann abhauen."
// requirement string "SEEN_COUNCIL=1"
// xp int 250
type string "sub_quest"
}

#quest Get to Democratus Fighter
{
quest_parent string "Find Central Controller"
area string "Democratus"
desc string "K[mpft bis zum Hangar des Kriegsschiffprototypes durch, mit dem ihr dann zu diesem Hive fliegt."
// xp int 250
xp_shares	float	1
type string "sub_quest"
}

//#########################################################################
// Hive
//#########################################################################
#quest Find Central Controller
{
area string "general"
desc string "Dringt in den Hive ein und findet die Steuerung der Raketen, um sie abzuschalten. Ich habe auch keine Ahnung, wie ihr das tun m#sst."
// xp int 5000
type string "quest"
}

#quest Beat Does Not Work
{
quest_parent string "Find Central Controller"
area string "Verilent Hive"
desc string "Die normalen Waffen scheinen der K<nigin keinen Schaden anzurichten. Vielleicht sind die MysTech-Waffen effektiver."// xp int 100
type string "sub_quest"
quest_parent string "Find Queen"
}

//#########################################################################
// Hephaestus
//#########################################################################

#quest Visit the MysTech Library
{ //set as soon as you come back from the hive; swapped out by "Get In Tower" once you debrief in hephpoor
area string "Hephaestus"
desc string "Besucht die MysTech-Bibliothek auf Hephaestus."
// xp int 1000
type string "quest"
}

#quest Get In Tower
//replace "Visit the MysTech Library" once you debrief with Grumpos in hephpoor
{
area string "Hephaestus"
desc string "Finde einen Weg in die MysTech-Bibliothek in dem Turm des Gro^en Mysteriums."
// xp int 1000
type string "quest"
}

#quest Finish Tower Tasks
{
area string "Hephaestus"
desc string "Du musst zwei Aufgaben l<sen, bevor der Abt euch in die MysTech-Bibliothek hineinl[^t:"
// xp int 1000
type string "quest"
}

#quest Seek Grand Mysterium Abbotless
//set during the universe scene, only if you HAVE NOT met the Abbot; swap with "Seek Grand Mysterium with Abbot" once ELEMENTOR_ACTIVE
{
area string "Hephaestus"
desc string "Bittet das Gro^e Mysterium auf Hephaestus um eine Audienz."
// xp int 1000
type string "quest"
}

#quest Seek Grand Mysterium with Abbot
//set during the universe scene, only if you HAVE met the Abbot
{
area string "Hephaestus"
desc string "Bittet das Gro^e Mysterium auf Hephaestus um eine Audienz. Der Abt im Turm des Gro^en Mysterium k<nnte f#r uns dieses Treffen organisieren."
// xp int 1000
type string "quest"
}

#quest Brave the Levant
{
quest_parent string "Seek Grand Mysterium with Abbot"
area string "Hephaestus"
desc string "Geht in das Zentrum des Mysterium-Levants, repariert die Maschinerie und bringt die Pumpe zum Laufen. Dann wird uns eine Audienz mit dem Gro^en Mysterium gew[hrt (sagt der Abt zumindest)."
// xp int 1000
type string "sub_quest"
}

#quest Find 3 Keys
{
quest_parent string "Finish Tower Tasks"
area string "Hephaestus"
desc string "Du musst im Fall des Verschwindens der Drei Schl#ssel des Cavatum im Turm des Gro^en Mysterium ermitteln."
// requirement string "FOUND_3KEYS_NOTE=1"
// xp int 1000
xp_shares	float	1
type string "sub_quest"
}

#quest Search Crime Scene
{
quest_parent string "Find 3 Keys"
area string "Hephaestus"
desc string "Siehe dich am Tatort um. Suche nach Anhaltspunkten. Setz deine F[higkeiten ein. Du wei^t schon... Wie ein Detective."
// xp int 1000
type string "sub_quest"
}

#quest Take Grit to Abbot
{
quest_parent string "Find 3 Keys"
area string "Hephaestus"
desc string "Nimm diesen Kies, den du am Tatort gefunden hast, zum Abt mit. Versuche, ein sicheres Auftreten zu haben."
// xp int 1000
type string "sub_quest"
}

#quest Find Brother Flammarion
{
quest_parent string "Find 3 Keys"
area string "Hephaestus"
desc string "Finde Bruder Flammarion, den Turmbibliothekar. Vielleicht kann er den Kies vom Tatort identifizieren."
// xp int 1000
type string "sub_quest"
}

#quest Follow Abbot
{
quest_parent string "Find 3 Keys"
area string "Hephaestus"
desc string "Folge Abt Babbit zur Lavaaufbereitungsfabrik."
// requirement string "been_to_factory=1"
// xp int 1000
type string "sub_quest"
}

#quest Malloy Fingered
{
quest_parent string "Find 3 Keys"
area string "Hephaestus"
desc string "Norman Malloy, Arbeiter in der Fabrik, wird des Diebstahls verd[chtigt."
// xp int 1000
type string "quest"
}

#quest Angela Fingered
{
quest_parent string "Find 3 Keys"
area string "Hephaestus"
desc string "Schwester Angela ist eine verd[chtige Frau und eine potentielle Kriminelle."
// xp int 1000
type string "sub_quest"
}

#quest Liseria Fingered
{
quest_parent string "Find 3 Keys"
area string "Hephaestus"
desc string "Bruder Liseria h[tte politische Gr#nde, diese Schl#ssel zu stehlen."
// xp int 1000
type string "sub_quest"
}

#quest Thomas Fingered
{
quest_parent string "Find 3 Keys"
area string "Hephaestus"
desc string "Thomas Litton, ein MysTech-H[ndler, k<nnte die Schl#ssel f#r den Verkauf am Schwarzmarkt gestohlen haben."
// xp int 1000
type string "sub_quest"
}

#quest Grit Clue
{
quest_parent string "Find 3 Keys"
area string "Hephaestus"
desc string "Besorge eine Kiesprobe in der N[he des Transporttunnels, damit sie mit dem Kies vom Tatort verglichen werden kann. Der Turmbibliothekar k<nnte eine Verbindung zwischen den beiden Kiesklumpen erkennen. Sch<n, was?"
// xp int 1000
type string "sub_quest"
}

#quest Train Grit
{
quest_parent string "Find 3 Keys"
area string "Hephaestus"
desc string "OK, lass uns die Kiesprobe aus dem Tunneltransport mit dem Kies vom Tatort vergleichen. Der Turmbibliothekar k<nnte zwischen den beiden Kiesklumpen eine Verbindung erkennen."
// xp int 1000
type string "sub_quest"
}

#quest Confront Restlin
{
quest_parent string "Find 3 Keys"
area string "Hephaestus"
desc string "Da wir nun eine Verbindung zwischen dem Kies aus dem Transporttunnel und dem Kies vom Tatort hergestellt haben, k<nnte Restlin Brewster vielleicht seine Meinung [ndern."
// xp int 1000
type string "sub_quest"
}

#quest Help For Angela
{
quest_parent string "Find 3 Keys"
area string "Hephaestus"
desc string "Finde ein anderes Party-Mitglied im Unterhaltungsviertel und #berzeuge es, dir bei der Beweissuche im Zimmer von Schwester Angela zu helfen."
// xp int 1000
type string "sub_quest"
}

#quest GOT Help For Angela
{
quest_parent string "Find 3 Keys"
area string "Hephaestus"
desc string "Kehrt zum Zimmer von Schwester Angela zur#ck und sucht nach Beweisen, die sie mit dem Diebstahl der Schl#ssel in Verbindung bringen k<nnten. Einer von euch soll sie ablenken, w[hrend der andere ihr Zimmer durchsucht."
// xp int 1000
type string "sub_quest"
}

#quest Help For Liseria
{
quest_parent string "Find 3 Keys"
area string "Hephaestus"
desc string "Finde ein anderes Party-Mitglied im Unterhaltungsviertel und #berzeuge es, dir bei der Beweissuche im Zimmer von Bruder Liseria zu helfen."
// xp int 1000
type string "sub_quest"
}

#quest GOT Help For Liseria
{
quest_parent string "Find 3 Keys"
area string "Hephaestus"
desc string "Kehrt zum Zimmer von Bruder Liseria zur#ck und sucht nach Beweisen, die ihn mit dem Diebstahl der Schl#ssel in Verbindung bringen k<nnten. Einer von euch soll ihn ablenken, w[hrend der andere sein Zimmer durchsucht.."
// xp int 1000
type string "sub_quest"
}

#quest Help For Thomas
{
quest_parent string "Find 3 Keys"
area string "Hephaestus"
desc string "Finde ein anderes Party-Mitglied im Unterhaltungsviertel und #berzeuge es, dir bei der Beweissuche im Zimmer von Thomas Litton zu helfen."
// xp int 1000
type string "sub_quest"
}

#quest GOT Help For Thomas
{
quest_parent string "Find 3 Keys"
area string "Hephaestus"
desc string "Kehrt zum Zimmer von Thomas Litton zur#ck und sucht nach Beweisen, die ihn mit dem Diebstahl der Schl#ssel in Verbindung bringen k<nnten. Einer von euch soll ihn ablenken, w[hrend der andere sein Zimmer durchsucht."
// xp int 1000
type string "sub_quest"
}

#quest Find Felicia
{
quest_parent string "Find 3 Keys"
area string "Hephaestus"
desc string "Triff in der Eco Bar die Komplizin von Schwester Angela, Felicia. Sie m#sste den Aufbewahrungsort der gestohlenen Schl#ssel kennen."
// xp int 1000
type string "sub_quest"
}

#quest Find Gray
{
quest_parent string "Find 3 Keys"
area string "Hephaestus"
desc string "Triff in der Eco Bar den Komplizen von Bruder Liseria, Bruder Gray. Er m#sste den Aufbewahrungsort der gestohlenen Schl#ssel kennen."
// xp int 1000
type string "sub_quest"
}

#quest Find Donald
{
quest_parent string "Find 3 Keys"
area string "Hephaestus"
desc string "Triff in der Eco Bar den Komplizen von Thomas Litton, Donald. Er m#sste den Aufbewahrungsort der gestohlenen Schl#ssel kennen."
// xp int 1000
type string "sub_quest"
}

#quest Search Room 3
{
quest_parent string "Find 3 Keys"
area string "Hephaestus"
desc string "Suche im Zimmer 3 bei Le Sommeil nach einem Hinweis auf den Aufbewahrungsort der gestohlenen Schl#ssel."
// xp int 1000
// requirement string "FOUND_3KEYS_NOTE=1"
type string "sub_quest"
}

#quest Take Three Keys Info To Abbot
{
quest_parent string "Find 3 Keys"
area string "Hephaestus"
desc string "Berichte dem Abt #ber den Aufenthaltsort der Drei Schl#ssel des Cavatum. Nicht schlecht, Chef. Das erinnert mich an die alten Tage."
// xp int 1000
type string "sub_quest"
}



#quest Get Fluid
{
quest_parent string "Finish Tower Tasks"
area string "Hephaestus"
desc string "Finde die Ersatzfl#ssigkeit f#r den Fl#ssigkeitsdichteanalysator in dem Schleusentor-Bereich der Lavaaufbereitungsfabrik."
// requirement string "GOT_FLUID=1"
// xp int 1000
xp_shares	float	1
type string "sub_quest"
}

#quest Get Fluid Back
{
quest_parent string "Finish Tower Tasks"
area string "Hephaestus"
desc string "Bringe die Ersatzfl#ssigkeit zum Abt."
// requirement string "GOT_FLUID=1"
// xp int 1000
type string "sub_quest"
}

#quest 4 Filters
{
quest_parent string "Get Fluid"
area string "Hephaestus"
desc string "Ersetze die Filter an vier Magmasaugern unten im Magmafilterbereich der Fabrik."
// requirement string "THREE_FILTERS=1"
// xp int 1000
type string "sub_quest"
}

#quest 3 Filters
{
quest_parent string "Get Fluid"
area string "Hephaestus"
desc string "Ersetze die Filter an drei Magmasaugern unten im Magmafilterbereich der Fabrik."
// requirement string "TWO_FILTERS=1"
// xp int 1000
type string "sub_quest"
}

#quest 2 Filters
{
quest_parent string "Get Fluid"
area string "Hephaestus"
desc string "Ersetze die Filter an zwei Magmasaugern unten im Magmafilterbereich der Fabrik."
// requirement string "ONE_FILTER=1"
// xp int 1000
type string "sub_quest"
}

#quest 1 Filter
{
quest_parent string "Get Fluid"
area string "Hephaestus"
desc string "Ersetze die Filter an einem Magmasauger unten im Magmafilterbereich der Fabrik."
// requirement string "DID_FILTERS=1"
// xp int 1000
type string "sub_quest"
}

#quest Find Pal in Ent Dist
{
area string "Hephaestus"
desc string "Finde PAL im Unterhaltungsviertel und kommt dann beide zur#ck in die Bibliothek."
// xp int 1000
type string "quest"
}

#quest Find Rho in Ent Dist
{
area string "Hephaestus"
desc string "Finde Rho im Unterhaltungsviertel und kommt dann beide zur#ck in die Bibliothek."
// xp int 1000
type string "quest"
}

#quest Find Democratus in Ent Dist
{
area string "Hephaestus"
desc string "Finde Democratus im Unterhaltungsviertel und kommt dann beide zur#ck in die Bibliothek."
// xp int 1000
type string "quest"
}

#quest Find Stiletto in Ent Dist
{
area string "Hephaestus"
desc string "Finde Stiletto, das Lederp#ppchen, im Unterhaltungsviertel und kommt dann beide zur#ck in die Bibliothek."
// xp int 1000
type string "quest"
}

#quest Go To Limbus
{
area string "Sender Station"
desc string "Lande auf Limbus, dem Planeten des Todes. W#rde mich interessieren, was wir dort finden werden. Sie vorsichtig, OK?"
// xp int 1000
type string "quest"
}

//#########################################################################
// KRAPTON
//#########################################################################

#quest Find Rictus
{
area string "Krapton"
desc string "Ahem. Superb<sewicht Rictus hat uns gefangen genommen. Suche nach Anhaltspunkten auf seinem Schiff, um seinem teuflischen Spiel zu entkommen und von diesem b<sen Ort zu fliehen. Tut mir echt Leid. Aber ich muss mir das Lachen wirklich verkneifen."
// xp int 50
type string "quest"
}

#quest Escape Krapton Jail
{
area string "Krapton"
desc string "Wunderbar, Boots. Du hast uns in dieses Schlamassel gebracht. Dann musst du uns auch retten!"
// xp int 50
xp_shares	float	1
type string "quest"
}

#quest Find Invisolad
{
quest_parent string "Escape Krapton Jail"
area string "Krapton"
desc string "Finde InvisoLad. Er versteckt sich in einer Ecke des Raums in der N[he der Eingangst#r."
// xp int 50
type string "sub_quest"
}

//#########################################################################
// DEMO QUEST: WHITENDON
//#########################################################################
// NAULS
#quest Go See the Burgomaster
{
area string "Whitendon"
desc string "Sprich mit B#rgermeister Bennings #ber die verschwundenen Stadtbewohner."
// xp int 50
type string "quest"
}
// BURGOMASTER
#quest Record Crime Scene
{
area string "Whitendon"
desc string "Finde den Tatort, fotografiere alles Ungew<hnliche und bringe die Fotos zum Chef, [hm... B#rgermeister."
// xp int 100
xp_shares	float	1
type string "quest"
}

#quest Record Fence Opening
{
area string "Whitendon"
desc string "Gehe an der Stadtumz[unung entlang und fotografiere alle ungew<hnlichen >ffnungen. Bringe dann die Fotos zum B#rgermeister."
// xp int 100
xp_shares	float	1
type string "quest"
}

#quest Record Anything Unusual
{
area string "Whitendon"
desc string "Sieh dich in der Stadt um, fotografiere alles Ungew<hnliche und bringe dann die Fotos zum B#rgermeister."
// xp int 100
xp_shares	float	1
type string "quest"
}

#quest Rest At Inn
{
area string "Whitendon"
desc string "Schlaf in der Taverne, bevor du dich deiner n[chsten Aufgabe in den Wei^en H<hlen widmest."
// xp int 100
type string "quest"
}

//#########################################################################
// DEMO QUEST: COMMITEON
//#########################################################################
#quest Paco Find Drink
{
area string "Commiteon"
desc string "Sie sehen sehr durstig aus, Mister Estrella. Vielleicht w#rden diese Soldaten hier Ihnen etwas zum Trinken anbieten."
// xp int 1000
type string "quest"
}

#quest Report to Sergeant Sargent
{
quest_parent string "Paco Find Drink"
area string "Commiteon"
desc string "Melden Sie sich bei Sergeant Major Sargent auf den n<rdlichen Seite des Lagers." 
// xp int 1000
type string "sub_quest"
}

#quest Report to Bibere
{
quest_parent string "Paco Find Drink"
area string "Commiteon"
desc string "Melden Sie sich bei Oberleutnant Bibere. Sein Feldcode lautet Shadow Cordica Obelisk Watcher Lithium."
// xp int 1000
type string "sub_quest"
}

#quest Report to Militaratus
{
quest_parent string "Paco Find Drink"
area string "Commiteon"
desc string "Melden Sie sich bei Captain Militaratus. Sein Feldcode ist Watcher Radium Astro Tentac Helium."
// xp int 1000
type string "sub_quest"
}

#quest Report to Tweedy
{
quest_parent string "Paco Find Drink"
area string "Commiteon"
desc string "Melden Sie sich bei Major Tweedy. Sein Feldcode lautet Shadow Photon Integer Tentac Eternal."
// xp int 1000
type string "sub_quest"
}

#quest Report to Irdgaff
{
quest_parent string "Paco Find Drink"
area string "Commiteon"
desc string "Melden Sie sich bei Oberstleutnant Irdgaff. Sein Feldcode ist Astro Neon Gambit Eternal Radium."
// xp int 1000
type string "sub_quest"
}

#quest Save Little Girl
{
area string "Commiteon"
desc string "Ich wei^ nicht, ob Sie sich immer noch f#r einen Superhelden halten, aber Sie m#ssen dieses kleine einheimische M[dchen aus der alten Milit[rbasis retten. Lassen Sie sie nicht im Stich."
// xp int 1000
type string "quest"
xp_shares	float	1
sub_quest string "Find Military Installation;Get Out of Base Camp;Report to Heten"
}

#quest Report to Heten
{
quest_parent string "Save Little Girl"
area string "Commiteon"
desc string "Vielleicht wei^ Oberstabsfeldwebel Heten etwas? Sein Feldcode lautet Gambit Radium Obelisk Watcher Lithium."
// xp int 1000
type string "sub_quest"
}

#quest Find Military Installation
{
quest_parent string "Save Little Girl"
area string "Commiteon"	
desc string "Zuerst m#ssen Sie den Standort der alten Basis herausfinden."
// xp int 1000
type string "sub_quest"
}

#quest Get Out of Base Camp
{
quest_parent string "Save Little Girl"
area string "Commiteon"	
desc string "Dann m#ssen Sie #berlegen, wie Sie aus diesem Lager hier herauskommen k<nnten."
// xp int 1000
xp_shares	float	1
type string "sub_quest"
}

#quest Use Code to Leave
{
quest_parent string "Get Out of Base Camp"
desc string "Sieht wie eine Zahlenkombination aus: 65712. Das k<nnte uns helfen, den Ausgang zu finden."
type string "sub_quest"
area string "Commiteon"	
}

//#########################################################################
// DEMO QUEST: BALLOTINE
//#########################################################################
#quest Find Emergency Shutoff
{
area string "Ballotine"
desc string "Wir k<nnen diese Menschen nicht im Stich lassen, PAL. Lass uns die manuelle Abschaltung f#r diese Fabrik finden, um die chemische Verschmutzung des Flusses durch die Abf[lle zu stoppen."
// xp int 1000
type string "quest"
}

#quest Shutoff in Pool 3
{
quest_parent string "Find Emergency Shutoff"
area string "Ballotine"
desc string "Der Notschalter ist im Abfluss 3."
// xp int 100
xp_shares	float	1
type string "sub_quest"
}

#quest Shutoff Complete
{
quest_parent string "Find Emergency Shutoff"
area string "Ballotine"
desc string "Der Notschalter wurde bet[tigt. Lass uns in die Stadt zur#ckkehren. Ich bin so stolz auf dich, PAL!"
// xp int 100
xp_shares	float	1
type string "sub_quest"
}


//#########################################################################
// TENSIL
//#########################################################################
#quest Find Party 
{
area string "Tensil"
desc string "Du musst es irgendwie schaffen, den Rest der Party zu finden. Aber erst m#ssen wir einen bev<lkerten Ort finden."
// xp int 1000
type string "quest"
}

#quest Rho Find Leaves
{
quest_parent string "Find Party"
area string "Tensil"
desc string "Finde vier goldene Bl[tter und bringe sie zu der Dorf[ltesten, damit sie dir deine Zukunft voraussagt."
// xp int 1000
xp_shares	float	1
type string "sub_quest"
}

#quest Get Ziffinberries
{
quest_parent string "Rho Find Leaves"
area string "Tensil"
desc string "Find zw<lf Vogelbeeren und bringe sie zu Sakima, um ein goldenes Blatt zu erhalten."
// xp int 20
type string "sub_quest"
}

#quest Get Silver Leaves
{
quest_parent string "Rho Find Leaves"
area string "Tensil"
desc string "Lonato w#rde dir ein goldenes Blatt f#r vier Silberbl[tter tauschen."
// xp int 20
type string "sub_quest"
}

#quest Cure Hanuman
{
quest_parent string "Rho Find Leaves"
area string "Tensil"
desc string "Bringe ein silbernes Blatt zu Hanuman und Wakanda, um sie zu heilen."
// xp int 0
type string "sub_quest"
}

#quest Enter the Temple
{
quest_parent string "Find Party"
area string "Tensil"
desc string "Betrete den Tempel und hole das Shii-Nei - Artefakt."
// xp int 5000
xp_shares	float	1
type string "sub_quest"
}

#quest Find Hedela
{
quest_parent string "Find Party"
area string "Tensil"
desc string "Gehe nochmal zu der Dorf[ltesten, bevor du die Stadt verl[sst."
// xp int 5000
type string "sub_quest"
}

#quest Leave Tensil
{
quest_parent string "Find Party"
area string "Tensil"
desc string "Verlasse die Stadt und gehe zur n[chsten Menschensiedlung."
// xp int 5000
type string "sub_quest"
}

//#########################################################################
// DOREN
//#########################################################################
#quest Doren Beats Me
{
area string "Doren"
desc string "Mir egal. Du bist auf dich selbst gestellt."
// xp int 1000
xp_shares	float	1
type string "quest"
}

#quest Doren Go To Sleep
{
area string "Doren"
desc string "Quartiermeister Richard kann dir ein Bett im Bunker besorgen, damit du deinen Sch<nheitsschlaf nicht verpasst."
// xp int 1000
type string "quest"
}

#quest Kill the Waugees
{
area string "Doren"
desc string "Du sollst die Waugee f#r Geld ausrotten."
// xp int 1000
type string "quest"
}

#quest Doren Report Back
{
area string "Doren"
desc string "Melde dich wieder bei Walton, um deine Belohnung zu bekommen. Wie stolz m#ssen deine Eltern auf dich sein!"
// xp int 1000
type string "quest"
}

#quest Doren Leave Camp
{
area string "Doren"
desc string "Verlasse die Basis und untersuche das Raumschiff."
// xp int 1000
type string "quest"
}

//#########################################################################
// WHITENDON PART II
//#########################################################################

#quest White Caves Find Child
{
area string "Whitendon"
desc string "Suche in den Wei^en H<hlen nach dem entf#hrten Jungen."
// xp int 100
type string "quest"
}

#quest White Caves Return
{
area string "Whitendon"
desc string "Gute Arbeit, Boots. Jetzt kannst du dem B#rgermeister von deinem Erfolg berichten."
// xp int 100
type string "quest"
}


//#########################################################################
// VOTOWNE PART II
//#########################################################################
#quest Rest at Republic
{
area string "Votowne"
desc string "Ihr solltet im Republik-Gasthof #bernachten, bevor ihr euch mit dem Rest der Party in der Lounge of Commerce auf Sender Station trefft."
// xp int 1000
type string "quest"
}

#quest Rendezvous with Party
{
area string "general"
desc string "Trefft euch mit dem Rest der Party in der Lounge of Commerce auf Sender Station."
// xp int 1000
type string "quest"
}

//#########################################################################
// LIMBUS
//#########################################################################
#quest Explore Limbus
{
area string "Limbus"
desc string "Uh... Seht euch nach ein paar interessanten Sachen um. Vielleicht finden wir etwas, was uns weitere Hinweise auf unser n[chstes Ziel geben k<nnte."
// xp int 500
type string "quest"
}

#quest Find Pillars
{
area string "Limbus"
desc string "Findet die Wachen der Sesostri und fragt sie nach der Lanze der Wachen."
// xp int 500
type string "quest"
}

#quest Find Bridge
{
area string "Limbus"
desc string "Besucht die Br#cke des Verrats an den Stadttoren."
// xp int 500
type string "quest"
}

#quest Find Cliff
{
area string "Limbus"
desc string "Findet den Abgrund der Verzweiflung irgendwo in Sesostri."
// xp int 500
type string "quest"
}

#quest Talk To Santa
{
area string "Limbus"
desc string "Sieh dich in der Stadt um, ob es Verletzte gibt, dann finde die anderen Party-Mitglieder und gehe zu Santadrimangetricus."
// xp int 500
//xp_shares	float	1
type string "quest"
}

// a hack to grant xp to the gunner in the limbus sequence

#quest Big Gun
{
area string "Limbus"
desc string "Du musst die Dunklen Diener abschie^en."
// xp int 500
xp_shares	float	1
type string "quest"
}



#quest Find Rowdy
{
area string "Limbus"
desc string "Finde Roweidekhalicon, ein Mitglied der Wachen, welches ein Getr[nke-Establishment in S#d-Anachronox besitzt."
// xp int 500
type string "quest"
}




//#########################################################################
// FORTRESS
//#########################################################################
#quest Get Keystone From Detta
{
area string "Anachronox"
desc string "Trefft euch mit dem Rest der Party und bereitet euch dann auf die Invasion von Dettas Festung in OneGate vor."
// xp int 500
type string "quest"
}

#quest Enter the Fortress
{
area string "Anachronox"
desc string "Wenn ihr euch sicher #ber eure Angriffsbereitschaft seid, dann fliegt zu Anachronox Tours und kauft euch die Tickets zu OneGate Station. Der Rest der Party wird auf euch in der N[he von Dettas Festung warten."
// xp int 1000
type string "sub_quest"
}

#quest Find Detta
{
area string "Anachronox"
desc string "Findet Detta."
// xp int 5000
type string "sub_quest"
}

#quest Retrieve Keystone
{
area string "Anachronox"
desc string "Findet den Schl#sselstein irgendwo hier in der Festung. Bitte seid alle sehr vorsichtig."
// xp int 10000
type string "sub_quest"
}
//#########################################################################
// FORTRESS - Grounds
//#########################################################################
#quest Find Basement Entrance
{
area string "Anachronox"
desc string "Findet den Eingang zu Dettas Festung."
// xp int 1000
type string "quest"
}
//#########################################################################
// FORTRESS - Basement
//#########################################################################
#quest Find A Way In
{
area string "Anachronox"
desc string "Seid vorsichtig und sucht nach allen m<glichen Hinweisen, um aus dem Keller der Festung in das Erdgeschoss zu kommen."
// xp int 1000
type string "quest"
}

#quest Find The Code
{
area string "Anachronox"
desc string "Findet den Code, um den Eingang zu der Festung zu <ffnen."
// xp int 1000
type string "quest"
}

#quest The Drunken Guard
{
area string "Anachronox"
desc string "Die Notiz von der betrunkenen Wache lautete: "Heute: FACE und 1 2 3 6 8 11 13 22". Was das auch immer bedeuten mag..."
// xp int 1000
type string "sub_quest"
quest_parent string "Find The Code"
}

#quest The Ad Paper
{
area string "Anachronox"
desc string "Auf dem Flyer, den wir gefunden haben, stand: "Coho Torque Beef Plaza. Die Auswahl ist klar." Viel Spa^."
// xp int 1000
type string "sub_quest"
quest_parent string "Find The Code"
}

#quest Decipher The Codes
{
area string "Anachronox"
desc string "Wir m#ssen diese Codes entschl#sseln."
// xp int 1000
type string "sub_quest"
quest_parent string "Find The Code"
}

#quest The Code Solution
{
area string "Anachronox"
desc string "Die Codel<sung lautet: HEUTE BITTE NUR UNGERADE EING]NGE BENUTZEN."
// xp int 1000
type string "sub_quest"
quest_parent string "Find The Code"
}

#quest Proceed Into Fortress
{
area string "Anachronox"
desc string "Seht euch nach offenen Eing[ngen um und springt dort hinein."
// xp int 1000
type string "quest"
}
//#########################################################################
// FORTRESS - Fortress1
//#########################################################################
#quest PAL DettaTerm Info
{
area string "Anachronox"
desc string "Auf dem DettaTerm, welchen PAL gefunden hat, stand "Heute: FACE"."
// xp int 1000
type string "sub_quest"
quest_parent string "Find Detta"
}

#quest Find Generator Code
{
area string "Anachronox"
desc string "Findet den Code f#r den Generator."
// xp int 1000
type string "sub_quest"
quest_parent string "Find Detta"
}

#quest Fortress Keynote
{
area string "Anachronox"
desc string "In der KeyNote, welche Stilettos Party gefunden hat, stand "4 17 1 2 5 6"."
// xp int 1000
type string "sub_quest"
quest_parent string "Find Detta"
}

//#########################################################################
// FORTRESS - Fortress1
//#########################################################################
#quest Head To The Workshop
{
area string "Anachronox"
desc string "Alle m#ssen sich im Arbeitsraum versammeln."
// xp int 1000
type string "sub_quest"
quest_parent string "Find Detta"
}


//#########################################################################
// SQUIRREL - TESTING
//#########################################################################

#quest SquirrelGrandfather
{
area string "Democratus"
desc string "SquirrelGrandfather"
// xp int 1000
type string "quest"
//sub_quest string "SquirrelFatherOne"
}

#quest SquirrelFatherOne
{
area string "Democratus"
desc string "SquirrelFatherOne"
// xp int 100
type string "sub_quest"
quest_parent string "SquirrelGrandfather"
sub_quest string "SquirrelChildOne"
}

#quest SquirrelChildOne
{
area string "Democratus"
desc string "SquirrelChildOne"
// xp int 10
quest_parent string "SquirrelFatherOne"
type string "sub_quest"
sub_quest string "SquirrelGrandChildOne;SquirrelGrandChildTwo;SquirrelGrandChildThree"
}

#quest SquirrelGrandChildOne
{
area string "Democratus"
desc string "SquirrelGrandChildOne"
// xp int 1
quest_parent string "SquirrelChildOne"
type string "sub_quest"
}

#quest SquirrelGrandChildTwo
{
area string "Democratus"
desc string "SquirrelGrandChildTwo"
// xp int 1
quest_parent string "SquirrelChildOne"
type string "sub_quest"
}

#quest SquirrelGrandChildThree
{
area string "Democratus"
desc string "SquirrelGrandChildThree"
// xp int 1
quest_parent string "SquirrelChildOne"
type string "sub_quest"
}




//@@@@@@@@@@@@@@@@@@@@@@@@@@@  NOTES @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//
// trick to print timed message on quest completion!  REQUIREMENTS ARE NO MORE!
//    // requirement "GOAL_COMPLETE=1;TIMED_MESSAGE=27"
//    quest_callback string "1000:1"



